/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime;

import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.Month;
import java.time.format.DateTimeParseException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.DateTimeFormatException;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.MonthKt;
import kotlinx.datetime.serializers.LocalDateTimeIso8601Serializer;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable(with=LocalDateTimeIso8601Serializer.class)
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 12\b\u0012\u0004\u0012\u00020\u00000\u0001:\u00011BC\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nBG\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u000b\u001a\u00060\fj\u0002`\r\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000eB\u000f\b\u0000\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u0011\u0010)\u001a\u00020\u00032\u0006\u0010*\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010+\u001a\u00020,2\b\u0010*\u001a\u0004\u0018\u00010-H\u0096\u0002J\b\u0010.\u001a\u00020\u0003H\u0016J\b\u0010/\u001a\u000200H\u0016R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0005\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0015\u0010\u0018\u001a\u00060\u0019j\u0002`\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0017R\u0011\u0010\u0006\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0017R\u0011\u0010\u0007\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0017R\u0015\u0010\u000b\u001a\u00060\fj\u0002`\r8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0011\u0010\u0004\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0017R\u0011\u0010\t\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0017R\u0011\u0010\b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0017R\u0014\u0010\u000f\u001a\u00020\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0017\u00a8\u00062"}, d2={"Lkotlinx/datetime/LocalDateTime;", "", "year", "", "monthNumber", "dayOfMonth", "hour", "minute", "second", "nanosecond", "(IIIIIII)V", "month", "Ljava/time/Month;", "Lkotlinx/datetime/Month;", "(ILjava/time/Month;IIIII)V", "value", "Ljava/time/LocalDateTime;", "(Ljava/time/LocalDateTime;)V", "date", "Lkotlinx/datetime/LocalDate;", "getDate", "()Lkotlinx/datetime/LocalDate;", "getDayOfMonth", "()I", "dayOfWeek", "Ljava/time/DayOfWeek;", "Lkotlinx/datetime/DayOfWeek;", "getDayOfWeek", "()Ljava/time/DayOfWeek;", "dayOfYear", "getDayOfYear", "getHour", "getMinute", "getMonth", "()Ljava/time/Month;", "getMonthNumber", "getNanosecond", "getSecond", "getValue$kotlinx_datetime", "()Ljava/time/LocalDateTime;", "getYear", "compareTo", "other", "equals", "", "", "hashCode", "toString", "", "Companion", "kotlinx-datetime"})
public final class LocalDateTime
implements Comparable<LocalDateTime> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final java.time.LocalDateTime value;
    @NotNull
    private static final LocalDateTime MIN;
    @NotNull
    private static final LocalDateTime MAX;

    public LocalDateTime(@NotNull java.time.LocalDateTime value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.value = value;
    }

    @NotNull
    public final java.time.LocalDateTime getValue$kotlinx_datetime() {
        return this.value;
    }

    /*
     * WARNING - void declaration
     */
    public LocalDateTime(int year, int monthNumber, int dayOfMonth, int hour, int minute, int second, int nanosecond) {
        java.time.LocalDateTime localDateTime;
        LocalDateTime localDateTime2;
        LocalDateTime localDateTime3 = this;
        try {
            localDateTime2 = localDateTime3;
            localDateTime = java.time.LocalDateTime.of(year, monthNumber, dayOfMonth, hour, minute, second, nanosecond);
        }
        catch (DateTimeException dateTimeException) {
            void e;
            LocalDateTime localDateTime4 = localDateTime3;
            throw new IllegalArgumentException((Throwable)e);
        }
        java.time.LocalDateTime localDateTime5 = localDateTime;
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime5, (String)"try {\n                jt\u2026xception(e)\n            }");
        localDateTime2(localDateTime5);
    }

    public /* synthetic */ LocalDateTime(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n8 & 0x20) != 0) {
            n6 = 0;
        }
        if ((n8 & 0x40) != 0) {
            n7 = 0;
        }
        this(n, n2, n3, n4, n5, n6, n7);
    }

    public LocalDateTime(int year, @NotNull Month month, int dayOfMonth, int hour, int minute, int second, int nanosecond) {
        Intrinsics.checkNotNullParameter((Object)month, (String)"month");
        this(year, MonthKt.getNumber(month), dayOfMonth, hour, minute, second, nanosecond);
    }

    public /* synthetic */ LocalDateTime(int n, Month month, int n2, int n3, int n4, int n5, int n6, int n7, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n7 & 0x20) != 0) {
            n5 = 0;
        }
        if ((n7 & 0x40) != 0) {
            n6 = 0;
        }
        this(n, month, n2, n3, n4, n5, n6);
    }

    public final int getYear() {
        return this.value.getYear();
    }

    public final int getMonthNumber() {
        return this.value.getMonthValue();
    }

    @NotNull
    public final Month getMonth() {
        Month month = this.value.getMonth();
        Intrinsics.checkNotNullExpressionValue((Object)month, (String)"value.month");
        return month;
    }

    public final int getDayOfMonth() {
        return this.value.getDayOfMonth();
    }

    @NotNull
    public final DayOfWeek getDayOfWeek() {
        DayOfWeek dayOfWeek = this.value.getDayOfWeek();
        Intrinsics.checkNotNullExpressionValue((Object)dayOfWeek, (String)"value.dayOfWeek");
        return dayOfWeek;
    }

    public final int getDayOfYear() {
        return this.value.getDayOfYear();
    }

    public final int getHour() {
        return this.value.getHour();
    }

    public final int getMinute() {
        return this.value.getMinute();
    }

    public final int getSecond() {
        return this.value.getSecond();
    }

    public final int getNanosecond() {
        return this.value.getNano();
    }

    @NotNull
    public final LocalDate getDate() {
        java.time.LocalDate localDate = this.value.toLocalDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"value.toLocalDate()");
        return new LocalDate(localDate);
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof LocalDateTime && Intrinsics.areEqual((Object)this.value, (Object)((LocalDateTime)other).value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @NotNull
    public String toString() {
        String string = this.value.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value.toString()");
        return string;
    }

    @Override
    public int compareTo(@NotNull LocalDateTime other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.value.compareTo(other.value);
    }

    static {
        java.time.LocalDateTime localDateTime = java.time.LocalDateTime.MIN;
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"MIN");
        MIN = new LocalDateTime(localDateTime);
        java.time.LocalDateTime localDateTime2 = java.time.LocalDateTime.MAX;
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime2, (String)"MAX");
        MAX = new LocalDateTime(localDateTime2);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bJ\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\rH\u00c6\u0001R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lkotlinx/datetime/LocalDateTime$Companion;", "", "()V", "MAX", "Lkotlinx/datetime/LocalDateTime;", "getMAX$kotlinx_datetime", "()Lkotlinx/datetime/LocalDateTime;", "MIN", "getMIN$kotlinx_datetime", "parse", "isoString", "", "serializer", "Lkotlinx/serialization/KSerializer;", "kotlinx-datetime"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LocalDateTime parse(@NotNull String isoString) {
            LocalDateTime localDateTime;
            Intrinsics.checkNotNullParameter((Object)isoString, (String)"isoString");
            try {
                java.time.LocalDateTime p0 = java.time.LocalDateTime.parse(isoString);
                boolean bl = false;
                localDateTime = new LocalDateTime(p0);
            }
            catch (DateTimeParseException e) {
                throw new DateTimeFormatException(e);
            }
            return localDateTime;
        }

        @NotNull
        public final LocalDateTime getMIN$kotlinx_datetime() {
            return MIN;
        }

        @NotNull
        public final LocalDateTime getMAX$kotlinx_datetime() {
            return MAX;
        }

        @NotNull
        public final KSerializer<LocalDateTime> serializer() {
            return LocalDateTimeIso8601Serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

